" Unit 3 - Lecture 3 "
"------------------------------------------------------------------------"

" Demonstration Of Central Limit Theorem "

" Claims amounts (Xi's) for a particular policy 
  are modelled using an exponential 
  distribution with mean 500.
 
 
 i.) Use seed of 1 and simulate a sample
     of size 100.
     
 ii.) Repeat i.) 1,000 such times and
      comment on the distribuion of
      summation of each of the Xi's using
      graphical method.

NOTE:
State the parameters clearly.
  
"

set.seed(1)
lambda = 1 / 500
SUMM = numeric()

for(i in 1:1000){
  
  X = rexp(100,lambda)
  SUMM[i] = sum(X)
  
}

hist(SUMM,freq = F)

N.X = seq(25000,75000,0.5)
PDF.N = dnorm(N.X,100*500,sqrt(100*500^2))

lines(N.X,
      PDF.N,
      col = "red")


"------------------------------------------------------------------------"
"
Understand:

- What is Hypothesis Testing?
- Steps involved
- Define Terminology
- One / Two tailed test
- Critical / Acceptance Region

"
"------------------------------------------------------------------------"
